"""
场景      武备情况                       要地半径        初始距要地中心距离       初始双机编队距离
超视距    2枚近距弹 + 4枚中距弹 + 机炮      100_000m         110_000m             5_000m
"""
# -------------设置----------------
control_mode = [0, 0, 3, 3] # 分别对应四架飞机的控制模式
# 协调转弯控制模式（编号3）：[油门，期望机体法向过载，期望机体滚转速率，无意义补充位]
# 操纵杆控制模式（编号0）：[油门，纵向杆，横向杆，方向舵]

from multifighters import config
config.control_mode = control_mode
from multifighters.simulation_env import CombatEnv
from pprint import pprint

if __name__ == '__main__':
    # ##################### 初始化设定 ########################

    # 初始化环境
    env = CombatEnv()

    # ###################### 多轮仿真 ######################
    for epoch in range(1):

        # 重置仿真环境
        situation_information = env.reset() # 初始时刻态势信息

        # # 打印每架飞机的数据
        # for num, inform in enumerate(situation_information):
        #     print(f'第{num}架飞机信息：')
        #     pprint(inform.__dict__)

        # ###################### 开始单轮仿真 ######################
        while True:
            ctrl_data = []          # 存储四架飞机的控制指令
            for num in range(4):    # 遍历四架飞机
                if num == 0:    # 第一架飞机
                    # 读取数据示例
                    # 假设读取第0架飞机的本机经纬高
                    lon = situation_information[0].self_data_dict['Longitude']
                    lat = situation_information[0].self_data_dict['Latitude']
                    alt = situation_information[0].self_data_dict['Altitude']

                    # ==============！！注意！！==============
                    # 每架飞机对仿真环境的感知仅能通过读取对应的situation_information数据
                    # 包括：
                    #       Data.self_data_dict      本机信息
                    #       Data.radar_data_dict     雷达探测信息
                    #       Data.AWACS_data_dict     预警机信息
                    #       Data.alert_data_dict     告警信息
                    #       Data.close_data_dict     近距透明信息
                    # 具体包含数据请查看./multifighters/EnvData.py 并对照文档查看变量定义
                    ctrl_data.append([
                        0,  # 仿真步长  (注：训练版本不需要传入有效值，但比赛版需要传入有效值来对齐仿真进度)
                        1, 1 / 9, 0, 0,  # 机动指令
                        0,  # 目标选择：敌机第一架飞机
                        0, 1, 1,  # 航炮+近距弹+中距弹 指令
                    ])
                else:   # 其余飞机
                    ctrl_data.append([
                        0,  # 仿真步长
                        1, 1 / 9, 0, 0,  # 机动指令
                        0,  # 目标选择：敌机第一架飞机
                        0, 1, 1,  # 航炮+近距弹+中距弹 指令
                    ])


            # 单个回合更新
            # 终止判断标志位， 仿真步长， 态势信息
            terminal, step, situation_information = env.update(ctrl_data)

            # 打印每架飞机的数据
            for num, inform in enumerate(situation_information):
                print(f'第{num}架飞机信息：')
                pprint(inform.__dict__)
            # 打印仿真进程信息
            print('\n仿真步长：', step, '仿真时间： ', f"{step * 0.1:.2f}s")
            print(f'蓝方占领时长：{env.score_board.blue_time:.2f}s 红方占领时长：{env.score_board.red_time:.2f}s')

            # # 如果需要截断仿真，重置仿真环境，调用env.reset即可
            # if step >= 100:
            #     env.reset()

            # 仿真结束
            if terminal >= 0:
                env.score_board.score_cal(terminal)
                # terminal 1:蓝方全灭 2：红方全灭 3：所有飞机死亡 4：一方的占领时长达到30s
                break



